IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GET_BED_SWITCH_ID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[GET_BED_SWITCH_ID]
GO

CREATE FUNCTION [dbo].[GET_BED_SWITCH_ID] 
(
	@PATIENT_ID INT,
	@WARD_ID INT,
	@VISTA_SITE_ID INT,
	@IEN VARCHAR(250)
)
RETURNS INT
AS
BEGIN
	
	DECLARE @BED_SWITCH_ID INT, @BED_SWITCH_IEN BIGINT
	
	SELECT @BED_SWITCH_IEN = MAX(CAST(IEN as BIGINT))
	FROM  dbo.FACT_BED_SWITCH  
    WHERE VISTA_SITE_DIM_ORGANIZATION_ID = @VISTA_SITE_ID  AND  
			DIM_WARD_ID = @WARD_ID AND DIM_PATIENT_ID = @PATIENT_ID 
			AND CAST(IEN AS BIGINT) > CAST(@IEN AS BIGINT)
		
   SELECT @BED_SWITCH_ID = ID 
   FROM dbo.FACT_BED_SWITCH
   WHERE IEN = CAST(@BED_SWITCH_IEN AS VARCHAR(250)) AND VISTA_SITE_DIM_ORGANIZATION_ID = @VISTA_SITE_ID
					   
	RETURN @BED_SWITCH_ID

END

GO


